#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
using namespace std;

typedef unsigned long long ull;

ull countDigits(ull num) {
    return floor(log2(num)) + 1;
}

ull invertBits(ull num, ull k) {
    return (~num) & ((1ULL << min(k, countDigits(num))) - 1);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int t;
    cin >> t;

    while (t--) {
        ull n;
        cin >> n;

        vector<ull> p(n + 1);
        vector<ull> q(n + 1);
        ull x = 0;

        for (ull i = 0; i <= n; i++)
            cin >> p[i];

        ull k = countDigits(n + 1);

        for (ull i = 0; i <= n; i++) {
            ull tmp = invertBits(p[i], k);
            q[i] = (tmp > n) ? (tmp - n - 1) : tmp;
            x += p[i] ^ q[i];
        }

        cout << x << '\n';

        for (ull i = 0; i <= n; i++)
            cout << q[i] << " ";

        if (t != 0)
            cout << '\n';
    }

    return 0;
}